/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.Utils;
import com.james.tinkerscalibration.effect.HeavyEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorHeavyModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> HEAVY = TConstruct.createKey((String)"heavy");

    public ArmorHeavyModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, ArmorHeavyModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(HEAVY, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(HEAVY, (Object)0);
            if (level > 0 && attacker instanceof LivingEntity) {
                LivingEntity attackerl = (LivingEntity)attacker;
                if (event.getAmount() != 0.0f) {
                    ((HeavyEffect)((Object)((Object)Utils.heavyEffect.get()))).apply(attackerl, 100, level, true);
                }
            }
        });
    }
}

